ORCA/M Asm65816 2.1.0

0001 0B89                       title 'QD INIT              GS ROM 3.0' 
0002 0B89              ****************************************************************
0003 0B89              *                                                              *
0004 0B89              *              Init                                            *
0005 0B89              *                                                              *
0006 0B89              ****************************************************************
0007 0B89
0008 0B89
0009 0B89              ****************************************************************
0010 0B89              *                                                              *
0011 0B89              *                  Copyright (C) 1985-1989                     *
0012 0B89              *                  All Rights Reserved                         *
0013 0B89              *                  Apple Computer, Inc.                        *
0014 0B89              *                                                              *
0015 0B89              ****************************************************************
0016 0B89
0017 0B89                       include 'all.macros' 
0018 0B89
0019 0B89
0020 0B89                       INCLUDE ':QDEquates:core.globals1' 
0021 0B89                       INCLUDE ':QDEquates:core.globals2' 
0022 0B89                       INCLUDE ':QDEquates:region.equs' 
0023 0B89
0024 0B89                       INCLUDE ':QDEquates:qd.data.asm' 
0025 0B89
0026 0B89                       include '::sys.equs.asm' 
0027 0B89
0028 0B89                       include 'e16.memory' 
0029 0B89
0030 0B89              TheCoreVersion equ   $0300              ; real version 3.0
0031 0B89
0032 0B89
0033 0B89              ****************************************************************
0034 0B89              *
0035 0B89              * CoreBootInit
0036 0B89              *
0037 0B89              * Installs the address of update cursor in the update
0038 0B89              * cursor vector of bank E1.
0039 0B89              *
0040 0B89              ****************************************************************
0041 0B89                       EXPORT CoreBootInit 
0042 0B89              CoreBootInit PROC 
0043 0B89
0044 0B89 F4 18 00              PushWord #CurUpdateRefNum      ; install pointer to update
0045 0B8C F4 FE 00 F4           PushPtr UpdateCursor           ; cursor routine
0046 0B92 A2 03 10 22           _SetVector 
0047 0B99
0048 0B99 F4 FE 00 F4           PushLong #E0Vectors            ; copy internal vectors to bank E0
0049 0B9F F4 E0 00              pea   $00E0
0050 0BA2 F4 00 1E              pea   $1E00
0051 0BA5 F4 00 00 F4           PushLong #$1FC                 ; TheE0VEnd-TheE0VStart
0052 0BAB A2 02 2B 22           _BlockMove 
0053 0BB2
0054 0BB2 4C DF FB              jmp   oEndCall0
0055 0BB5
0056 0BB5                       ENDP 
0057 0BB5
0058 0BB5
0059 0BB5              ****************************************************************
0060 0BB5              *
0061 0BB5              * CoreApInit        (ZPToUse : word;
0062 0BB5              *                    MasterSCB : word;
0063 0BB5              *                    MaxWidth : word;
0064 0BB5              *                    ApID : word);
0065 0BB5              *
0066 0BB5              *
0067 0BB5              * Modifications
0068 0BB5              *
0069 0BB5              *     April 8, 1986	   I now check for errors correctly after
0070 0BB5              *	   GetTextHandle.
0071 0BB5              *
0072 0BB5              *     April 30, 1986   I finally handle the special case where
0073 0BB5              *	   MaxWidth is a 0 on entry.  Also the clip buffer
0074 0BB5              *	   sizing is now a subroutine that can be called
0075 0BB5              *	   from SetMaxWidth.  This way the buffer can be
0076 0BB5              *	   changed.
0077 0BB5              *
0078 0BB5              *     May 2, 1986	   I now do text buffer sizing directly since
0079 0BB5              *	   it is not automatic in my OpenPort and SetPort
0080 0BB5              *
0081 0BB5              *     Dec 23, 1986	   Code clean up and compression.
0082 0BB5              *
0083 0BB5              *     2/17/88   GCP	   changed zero loop to clear third zero page
0084 0BB5              *
0085 0BB5              *     2/1/89 Mensch	Added Bitflag support for the top byte of the
0086 0BB5              *	MasterSCB flag. These flags can be used to select
0087 0BB5              *	various quickdraw options that we couldn't use before.
0088 0BB5              *
0089 0BB5              ****************************************************************
0090 0BB5                       EXPORT CoreApInit 
0091 0BB5              CoreApInit PROC 
0092 0BB5
0093 0BB5              OrigDirect equ   1
0094 0BB5              RTL1     equ   OrigDirect+2
0095 0BB5              RTL2     equ   RTL1+3
0096 0BB5              TheUserID equ   RTL2+3
0097 0BB5              TheMaxWidth equ   TheUserID+2
0098 0BB5              TheMasterSCB equ   TheMaxWidth+2
0099 0BB5              PtrToZP  equ   TheMasterSCB+2
0100 0BB5
0101 0BB5              ; New MasterSCB Equates we can use
0102 0BB5              UseShadow equ   $8000
0103 0BB5              HiddenSpeed equ   $4000
0104 0BB5              Avail1   equ   $2000
0105 0BB5              Avail2   equ   $1000
0106 0BB5
0107 0BB5 22 64 00 E1           jsl   IncBusyFlg
0108 0BB9
0109 0BB9              ;-----------------------------------------------
0110 0BB9              ;
0111 0BB9              ; See if the last user has shut down.
0112 0BB9              ;
0113 0BB9 C9 00 00              cmp   #0
0114 0BBC F0 06                 beq   continue
0115 0BBE
0116 0BBE A2 01 04              ldx   #AlreadyInitialized
0117 0BC1 4C 49 FC              jmp   oBusyErr8
0118 0BC4
0119 0BC4              ;-----------------------------------------------
0120 0BC4              ;
0121 0BC4              ; Set up my entry in WAP
0122 0BC4
0123 0BC4              continue                                ; 
0124 0BC4
0125 0BC4 0B                    phd                            ; save direct
0126 0BC5
0127 0BC5 A3 0F                 lda   PtrToZP,s
0128 0BC7
0129 0BC7 F4 00 00              PushWord #0                    ; Not a user call
0130 0BCA F4 04 00              PushWord #TSNumber             ; Put TSNum on stack
0131 0BCD
0132 0BCD F4 00 00              PushWord #0                    ; High word is zero
0133 0BD0 48                    pha                            ; low word is in a
0134 0BD1
0135 0BD1 A2 01 0D 22           _SetWAP 
0136 0BD8
0137 0BD8
0138 0BD8              ;-----------------------------------------------
0139 0BD8              ;
0140 0BD8              ; Move important values to zero page
0141 0BD8
0142 0BD8 A3 0F                 lda   PtrToZP,s                ; initialize some stuff
0143 0BDA 5B                    tcd   
0144 0BDB
0145 0BDB              ;-------------------------------------------------
0146 0BDB              ;
0147 0BDB              ; But first initialize it to zero.  (This is
0148 0BDB              ; important for handles so that those not allocated
0149 0BDB              ; in an errant attempt to startup are not disposed
0150 0BDB              ; of illegally!
0151 0BDB              ;
0152 0BDB A2 00 00              ldx   #0
0153 0BDE 74 00        ZeroLoop stz   0,x
0154 0BE0 E8                    inx   
0155 0BE1 E8                    inx   
0156 0BE2 E0 00 03              cpx   #768
0157 0BE5 90 F7                 bcc   ZeroLoop
0158 0BE7
0159 0BE7
0160 0BE7 A3 0B                 lda   TheMaxWidth,s            ; zero is special number that I fix
0161 0BE9 C9 00 00              cmp   #0
0162 0BEC D0 03                 bne   UseThisOne
0163 0BEE A9 A0 00              lda   #160
0164 0BF1 85 28        UseThisOne sta   MaxWidth
0165 0BF3 A3 0D                 lda   TheMasterSCB,s
0166 0BF5 85 08                 sta   MasterSCB
0167 0BF7 A3 09                 lda   TheUserID,s
0168 0BF9 85 0A                 sta   UserID
0169 0BFB
0170 0BFB              ;-----------------------------------------------
0171 0BFB              ;
0172 0BFB              ; reserve the super hi-res screen so that
0173 0BFB              ; no one else will get it.
0174 0BFB              ;
0175 0BFB
0176 0BFB 48                    pha                            ; space for handle
0177 0BFC 48                    pha   
0178 0BFD F4 00 00 F4           PushLong #$8000                ; size of screen
0179 0C03 D4 0A                 pei   UserID
0180 0C05 F4 02 C0              PushWord #$C002                ; fixed location, locked
0181 0C08 F4 E1 00              pea   $00E1
0182 0C0B F4 00 20              pea   $2000
0183 0C0E 22 1F 13 FE           jsl   NewHandleGlue
0184 0C12 90 08                 bcc   GotScreen
0185 0C14
0186 0C14 68                    pla   
0187 0C15 68                    pla   
0188 0C16 A9 10 04              lda   #ScreenReserved
0189 0C19 4C 60 0D              jmp   CannotInitialize
0190 0C1C
0191 0C1C
0192 0C1C
0193 0C1C
0194 0C1C              GotScreen                               ; 
0195 0C1C A2 00 01              ldx   #256                     ; save this for later
0196 0C1F 68                    pla   
0197 0C20 95 06                 sta   ScreenHandle,x
0198 0C22 68                    pla   
0199 0C23 95 08                 sta   ScreenHandle+2,x
0200 0C25
0201 0C25              ;
0202 0C25              ; EXP 1/25/89 see if we can allocate the shadowed screen, if so, do it!
0203 0C25              ; EXPERIMENT 1 aprox 10% speed increase
0204 0C25 A2 00 02              ldx   #512                     ; switch to qd dpage 2
0205 0C28 A5 08                 lda   MasterSCB                ; get the passed flags from the top of MasterSCB
0206 0C2A 29 00 40              and   #$4000                   ; strip off the high bit 14 ...
0207 0C2D F0 03                 beq   @NoDirty
0208 0C2F A9 00 80              lda   #$8000
0209 0C32 95 EC        @NoDirty sta   <DirtyDPFlags,x          ; and save this value...
0210 0C34
0211 0C34 A5 08                 lda   MasterSCB
0212 0C36 10 32                 bpl   EXP0020                  ; if carry clear, no shadowing!
0213 0C38
0214 0C38 48                    pha                            ; space for handl
0215 0C39 48                    pha   
0216 0C3A F4 00 00 F4           PushLong #$8000                ; size of screen
0217 0C40 D4 0A                 pei   UserID
0218 0C42 F4 02 C0              PushWord #$C002                ; fixed location, locked
0219 0C45 F4 01 00              pea   $0001
0220 0C48 F4 00 20              pea   $2000
0221 0C4B 22 1F 13 FE           jsl   NewHandleGlue
0222 0C4F 68                    pla                            ; discard trhis handle for now...
0223 0C50 FA                    plx   
0224 0C51 B0 10                 bcs   EXP0010                  ; if an error, then we didn't allocate Shadow screen
0225 0C53
0226 0C53              ; If we get this far, we have allocated a shadowed screen and we should now set
0227 0C53              ; the shadowing bit on for the SHR screen.
0228 0C53 E2 20                 sep   #$20                     ; turn off long <A>
0229 0C55                       longa off
0230 0C55 AF 35 C0 E0           lda   >$E0C035                 ; load the shadow register
0231 0C59 29 F7                 and   #$F7                     ; reset bit 3...
0232 0C5B 8F 35 C0 E0           sta   >$E0C035                 ; and resave it!
0233 0C5F                       longa on
0234 0C5F C2 20                 rep   #$20                     ; and turn back on long <A>
0235 0C61 80 07                 bra   EXP0020
0236 0C63              EXP0010   
0237 0C63              ; Shadowing didn't get allocated, lets change our bitflags here
0238 0C63 A5 08                 lda   MasterSCB
0239 0C65 29 FF 7F              and   #$7FFF                   ; strip off the shadow flag
0240 0C68 85 08                 sta   MasterSCB                ; to indicate we are not using shadowing.
0241 0C6A              EXP0020   
0242 0C6A              ;
0243 0C6A              ; END of Experiment!
0244 0C6A
0245 0C6A              ;-----------------------------------------------
0246 0C6A              ;
0247 0C6A              ; Turn linearization on
0248 0C6A
0249 0C6A E2 20                 sep   #%00100000               ; 8 bit a-reg
0250 0C6C                       longa off
0251 0C6C AF 29 C0 00           lda   >NewVideo
0252 0C70 09 40                 ora   #$40                     ; only linearize first
0253 0C72 8F 29 C0 00           sta   >NewVideo
0254 0C76 C2 20                 rep   #%00100000               ; back to 16 bits
0255 0C78                       longa on
0256 0C78
0257 0C78
0258 0C78              ;-----------------------------------------------
0259 0C78              ;
0260 0C78              ; Call bennet to initialize the Text Buffer Handle
0261 0C78              ;
0262 0C78 22 6C 1F E0           jsl   GetTextHandle
0263 0C7C 90 03                 bcc   GotText
0264 0C7E
0265 0C7E 4C 60 0D              jmp   CannotInitialize
0266 0C81
0267 0C81
0268 0C81              GotText                                 ; 
0269 0C81              ;-----------------------------------------------
0270 0C81              ;
0271 0C81              ; Init the SCB's and color table
0272 0C81              ;
0273 0C81
0274 0C81              ; 2/1/89 Mensch
0275 0C81              ; Added new flags on the top of the MasterSCB variable.
0276 0C81              ; Must strip them off before we use them here.
0277 0C81
0278 0C81 A5 08                 lda   MasterSCB
0279 0C83 29 FF 00              and   #$00FF                   ; strip off QD flags
0280 0C86 48                    pha   
0281 0C87 A2 04 14 22           _SetAllSCBs 
0282 0C8E
0283 0C8E F4 E1 00              pea   FirstTable>>16
0284 0C91 F4 00 9E              pea   FirstTable**$FFFF
0285 0C94 A2 04 0D 22           _InitColorTable 
0286 0C9B
0287 0C9B
0288 0C9B              ;-----------------------------------------------
0289 0C9B              ;
0290 0C9B              ; Init the cursor and clear the screen to
0291 0C9B              ; black.
0292 0C9B
0293 0C9B 22 C2 4E FE           jsl   InitCursor
0294 0C9F C9 00 00              cmp   #0
0295 0CA2 F0 03                 beq   DidCursor
0296 0CA4
0297 0CA4 4C 60 0D              jmp   CannotInitialize
0298 0CA7
0299 0CA7
0300 0CA7              DidCursor                               ; 
0301 0CA7 F4 00 00              PushWord #0                    ; clear the screen to black
0302 0CAA A2 04 15 22           _ClearScreen 
0303 0CB1
0304 0CB1
0305 0CB1              ;-------------------------------------------------
0306 0CB1              ;
0307 0CB1              ; Setup  the current system font on zero page.
0308 0CB1              ;
0309 0CB1 A2 00 01              ldx   #256
0310 0CB4 A9 1B DD              lda   #SystemFont
0311 0CB7 95 4E                 sta   SysFont,x
0312 0CB9 A9 FC 00              lda   #^SystemFont
0313 0CBC 95 50                 sta   SysFont+2,x
0314 0CBE
0315 0CBE              ;-----------------------------------------------
0316 0CBE              ;
0317 0CBE              ; Get space for the things we need.
0318 0CBE
0319 0CBE A9 28 28              lda   #10280                   ; size of handle
0320 0CC1 A6 0A                 ldx   UserID                   ; userid to use
0321 0CC3 A0 00 03              ldy   #$0300                   ; attributes
0322 0CC6 20 3B 13              jsr   SpecialNewHandle
0323 0CC9 90 03                 bcc   GotCache
0324 0CCB
0325 0CCB 4C 60 0D              jmp   CannotInitialize
0326 0CCE              GotCache                                ; ;low word is in x, high word in y
0327 0CCE 8A                    txa                            ; need x for indexing
0328 0CCF A2 F4 02              ldx   #$02F4                   ; third zero page of qd
0329 0CD2 95 00                 sta   0,x
0330 0CD4 94 02                 sty   2,x
0331 0CD6
0332 0CD6
0333 0CD6
0334 0CD6              ;-----------------------------------------------------------
0335 0CD6              ;
0336 0CD6              ; Get the fast font if we can...
0337 0CD6              ;
0338 0CD6              ; MODIFIED TEMP
0339 0CD6                       import DoFastSetup 
0340 0CD6
0341 0CD6 7B                    tdc   
0342 0CD7 48                    pha   
0343 0CD8 48                    pha                            ; room for result...
0344 0CD9 22 4C 13 FE           jsl   DoFastSetup
0345 0CDD 68                    pla   
0346 0CDE 7A                    ply   
0347 0CDF B0 0E                 bcs   @noFastFont
0348 0CE1 A2 00 01              ldx   #256
0349 0CE4 95 4E                 sta   SysFont,x
0350 0CE6 94 50                 sty   SysFont+2,x
0351 0CE8
0352 0CE8 A2 00 02              ldx   #512
0353 0CEB 95 F0                 sta   FastRomFont,x
0354 0CED 94 F2                 sty   FastRomFont+2,x
0355 0CEF              @NoFastFont  
0356 0CEF
0357 0CEF
0358 0CEF
0359 0CEF              ;
0360 0CEF              ; first the initial graf port.
0361 0CEF              ;
0362 0CEF A9 AA 00              lda   #PortSize                ; size of handle
0363 0CF2 A6 0A                 ldx   UserID                   ; userid to use
0364 0CF4 A0 00 40              ldy   #attrFixed               ; attributes
0365 0CF7 20 3B 13              jsr   SpecialNewHandle
0366 0CFA 90 03                 bcc   GotPort
0367 0CFC
0368 0CFC 4C 60 0D              jmp   CannotInitialize
0369 0CFF
0370 0CFF
0371 0CFF              GotPort                                 ; 
0372 0CFF 86 2A                 stx   Temp
0373 0D01 84 2C                 sty   Temp+2
0374 0D03 8A                    txa   
0375 0D04 A2 00 01              ldx   #256
0376 0D07 95 0A                 sta   FirstPortHandle,x        ; put a copy of the handle
0377 0D09 98                    tya   
0378 0D0A 95 0C                 sta   FirstPortHandle+2,x
0379 0D0C A0 02 00              ldy   #2                       ; deref the handle
0380 0D0F B7 2A                 lda   [Temp],y
0381 0D11 48                    pha   
0382 0D12 A7 2A                 lda   [Temp]
0383 0D14 48                    pha   
0384 0D15 A2 04 18 22           _OpenPort                      ; make open port call
0385 0D1C
0386 0D1C 90 03                 bcc   PortIsOpen
0387 0D1E
0388 0D1E 4C 60 0D              jmp   CannotInitialize
0389 0D21
0390 0D21
0391 0D21              PortIsOpen                              ; 
0392 0D21              ;----------------------------------------------------
0393 0D21              ;
0394 0D21              ; We have a port, so now set up the default
0395 0D21              ; text buffer size.
0396 0D21              ;
0397 0D21 A9 28 00              lda   #40
0398 0D24 85 52                 sta   NewMaxFontWidth
0399 0D26 A9 14 00              lda   #20
0400 0D29 85 50                 sta   NewTBHeight
0401 0D2B 64 56                 stz   ForcedFont
0402 0D2D 22 A8 1F E0           jsl   SetTB
0403 0D31 90 03                 bcc   BufIsSized
0404 0D33
0405 0D33 4C 60 0D              jmp   CannotInitialize
0406 0D36
0407 0D36              BufIsSized                              ; 
0408 0D36
0409 0D36 A5 28                 lda   MaxWidth
0410 0D38 20 6E 0D              jsr   CalcClipSize
0411 0D3B
0412 0D3B A6 0A                 ldx   UserID
0413 0D3D A0 00 00              ldy   #0
0414 0D40 20 3B 13              jsr   SpecialNewHandle
0415 0D43 90 03                 bcc   GotBuffer
0416 0D45
0417 0D45 4C 60 0D              jmp   CannotInitialize
0418 0D48
0419 0D48              GotBuffer                               ; 
0420 0D48 86 3C                 stx   BufferHandle
0421 0D4A 84 3E                 sty   BufferHandle+2
0422 0D4C
0423 0D4C A2 00 01              ldx   #256
0424 0D4F A9 01 00              lda   #1
0425 0D52 95 00                 sta   RandSeed,x
0426 0D54 74 02                 stz   RandSeed+2,x
0427 0D56
0428 0D56 A2 04 0A 22           _GrafOn 
0429 0D5D
0430 0D5D
0431 0D5D 4C 45 FC              jmp   BusyEC8
0432 0D60
0433 0D60
0434 0D60              CannotInitialize                        ; 
0435 0D60 85 0A                 sta   UserID                   ;use this to store error code
0436 0D62
0437 0D62              ;-------------------------------------------------
0438 0D62              ;
0439 0D62              ; Now I have to unwind, releasing any memory
0440 0D62              ; I may have successfully obtained before
0441 0D62              ; failing.
0442 0D62              ;
0443 0D62
0444 0D62
0445 0D62 A2 04 03 22           _QDShutdown 
0446 0D69
0447 0D69
0448 0D69 A6 0A                 ldx   UserID
0449 0D6B 4C 48 FC              jmp   BusyErr8
0450 0D6E
0451 0D6E
0452 0D6E
0453 0D6E                       ENDP 
0454 0D6E
0455 0D6E
0456 0D6E
0457 0D6E              ****************************************************************
0458 0D6E              *
0459 0D6E              * CalcClipSize
0460 0D6E              *
0461 0D6E              * We need a memory for the scan line buffers and
0462 0D6E              * three region state records.
0463 0D6E              * It needs to be
0464 0D6E              *
0465 0D6E              *    Size = MaxWidth + MaxWidth * 3 * 4 / 8 +
0466 0D6E              *              3 * StateRecSize
0467 0D6E              *
0468 0D6E              ****************************************************************
0469 0D6E
0470 0D6E                       EXPORT CalcClipSize 
0471 0D6E              CalcClipSize PROC 
0472 0D6E
0473 0D6E 48                    pha                            ; put max width on stack
0474 0D6F
0475 0D6F 18                    clc   
0476 0D70 63 01                 adc   1,s
0477 0D72 63 01                 adc   1,s
0478 0D74 4A                    lsr   a
0479 0D75
0480 0D75 18                    clc   
0481 0D76 63 01                 adc   1,s
0482 0D78
0483 0D78 18                    clc   
0484 0D79 69 60 00              adc   #3*StateRecSize
0485 0D7C
0486 0D7C FA                    plx   
0487 0D7D
0488 0D7D 60                    rts   
0489 0D7E
0490 0D7E
0491 0D7E                       ENDP 
0492 0D7E
0493 0D7E
0494 0D7E
0495 0D7E              ****************************************************************
0496 0D7E              *
0497 0D7E              * CoreTerminate
0498 0D7E              *
0499 0D7E              * Releases the memory held for scan line buffers, cursor
0500 0D7E              * save areas, text buffers.
0501 0D7E              *
0502 0D7E              * 3/14/89	Mensch
0503 0D7E              * Fixed up terminate to not dispose of the fastfont...
0504 0D7E              ****************************************************************
0505 0D7E                       EXPORT CoreTerminate 
0506 0D7E              CoreTerminate PROC 
0507 0D7E
0508 0D7E C9 00 00              cmp   #0
0509 0D81 D0 03                 bne   Continue
0510 0D83 4C DF FB              jmp   oEndCall0
0511 0D86
0512 0D86 20 AA 0F     Continue jsr   QDStart
0513 0D89 F4 02 00              pea   #2                       ; set the purge level to 2
0514 0D8C A2 00 02              ldx   #512                     ; on the fastfont...
0515 0D8F B5 F2                 lda   FastRomFont+2,x
0516 0D91 29 FF 00              and   #$00FF
0517 0D94 48                    pha   
0518 0D95 B5 F0                 lda   FastRomFont,x
0519 0D97 48                    pha   
0520 0D98 A2 02 24 22           _SetPurge 
0521 0D9F              ;	jsl	DisposeHandleGlue
0522 0D9F              *
0523 0D9F              * Deallocate rgn cache memory
0524 0D9F              *
0525 0D9F A2 F4 02              ldx   #$02F4
0526 0DA2 B5 02                 lda   2,x
0527 0DA4 48                    pha   
0528 0DA5 B5 00                 lda   0,x
0529 0DA7 48                    pha   
0530 0DA8 22 27 13 FE           jsl   DisposeHandleGlue
0531 0DAC
0532 0DAC              ;-----------------------------------------------
0533 0DAC              ;
0534 0DAC              ; Close the first port and get rid of the memory
0535 0DAC              ; it is in.
0536 0DAC              ;
0537 0DAC A2 00 01              ldx   #256
0538 0DAF B5 0C                 lda   FirstPortHandle+2,x
0539 0DB1 48                    pha   
0540 0DB2 85 2C                 sta   temp+2
0541 0DB4 B5 0A                 lda   FirstPortHandle,x
0542 0DB6 48                    pha   
0543 0DB7 85 2A                 sta   temp
0544 0DB9 A7 2A                 lda   [temp]
0545 0DBB AA                    tax   
0546 0DBC A0 02 00              ldy   #2
0547 0DBF B7 2A                 lda   [temp],y
0548 0DC1 48                    pha   
0549 0DC2 DA                    phx   
0550 0DC3 A2 04 1A 22           _ClosePort 
0551 0DCA 22 27 13 FE           jsl   DisposeHandleGlue
0552 0DCE
0553 0DCE              ;-----------------------------------------------
0554 0DCE              ;
0555 0DCE              ; Get rid of text buffer
0556 0DCE              ;
0557 0DCE A5 46 48 A5           PushLong TextBufHandle 
0558 0DD4 22 27 13 FE           jsl   DisposeHandleGlue
0559 0DD8
0560 0DD8
0561 0DD8              ;-----------------------------------------------
0562 0DD8              ;
0563 0DD8              ; Get rid of the buffer memory
0564 0DD8
0565 0DD8 D4 3E                 pei   BufferHandle+2
0566 0DDA D4 3C                 pei   BufferHandle
0567 0DDC 22 27 13 FE           jsl   DisposeHandleGlue
0568 0DE0
0569 0DE0              ;-----------------------------------------------
0570 0DE0              ; Get rid of shadowed ram here
0571 0DE0              ; test for shadowing enabled, if it is, turn it off and 
0572 0DE0              ; dispose of the screen...
0573 0DE0 E2 20                 sep   #$20                     ; turn off long <A>
0574 0DE2                       longa off
0575 0DE2 AF 35 C0 E0           lda   >$E0C035                 ; load the shadow register
0576 0DE6 29 08                 and   #$08                     ; set bit 3... (turn screen shadow off)
0577 0DE8 D0 18                 bne   @NotShadowed
0578 0DEA                       longa on
0579 0DEA C2 20                 rep   #$20                     ; and turn back on long <A>
0580 0DEC
0581 0DEC 48                    pha   
0582 0DED 48                    pha   
0583 0DEE F4 01 00              pea   $0001                    ; find the shadowed screen memory
0584 0DF1 F4 00 20              pea   $2000                    ; handle, shadowing was on...
0585 0DF4 A2 02 1A 22           _FindHandle 
0586 0DFB A2 02 10 22           _DisposeHandle                 ; and throw it the hell away..
0587 0E02              @NotShadowed  
0588 0E02                       longa on
0589 0E02 C2 20                 rep   #$20
0590 0E04              ;-----------------------------------------------
0591 0E04              ;
0592 0E04              ; Now get rid of screen memory.  Cannot do a find
0593 0E04              ; since we could be called after a startup call
0594 0E04              ; that was aborted because screen was already
0595 0E04              ; owned.  We don't want to release someone
0596 0E04              ; else's memory.
0597 0E04              ;
0598 0E04 A2 00 01              ldx   #256
0599 0E07 B5 08                 lda   ScreenHandle+2,x
0600 0E09 48                    pha   
0601 0E0A B5 06                 lda   ScreenHandle,x
0602 0E0C 48                    pha   
0603 0E0D 22 27 13 FE           jsl   DisposeHandleGlue
0604 0E11
0605 0E11              ;-----------------------------------------------
0606 0E11              ;
0607 0E11              ; Get rid of the memory used by cursor save
0608 0E11              ;
0609 0E11 20 B2 4F              jsr   CursorShutDown
0610 0E14
0611 0E14
0612 0E14              ;-----------------------------------------------
0613 0E14              ;
0614 0E14              ; Clear the entry in the WAPT
0615 0E14              ;
0616 0E14 A9 00 00              lda   #0                       ; not a user call (seed the a-reg
0617 0E17 48                    pha                            ; to save bytes below
0618 0E18 F4 04 00              PushWord #TSNumber             ; Put TSNum on stack
0619 0E1B 48                    pha                            ; new value is zero as set above.
0620 0E1C 48                    pha   
0621 0E1D A2 01 0D 22           _SetWAP 
0622 0E24
0623 0E24
0624 0E24              ;----------------------------------------------------
0625 0E24              ;
0626 0E24              ; Turn off graphics and linearization in bank 1/E1
0627 0E24              ;
0628 0E24 E2 30                 sep   #$30                     ; go to 8 bit mode
0629 0E26                       longa off
0630 0E26                       longi off
0631 0E26 AF 29 C0 00           lda   >NewVideo
0632 0E2A 29 3F                 and   #%00111111               ; turn off graphics and linearization
0633 0E2C 8F 29 C0 00           sta   >NewVideo
0634 0E30 C2 30                 rep   #$30                     ; go back to 16
0635 0E32                       longi on
0636 0E32                       longa on
0637 0E32
0638 0E32              ;------------------------------------------------------
0639 0E32              ; Turn off shadowing for the SHR Screen
0640 0E32              ;
0641 0E32 E2 20                 sep   #$20                     ; turn off long <A>
0642 0E34                       longa off
0643 0E34 AF 35 C0 E0           lda   >$E0C035                 ; load the shadow register
0644 0E38 09 08                 ora   #$08                     ; set bit 3... (turn screen shadow off)
0645 0E3A 8F 35 C0 E0           sta   >$E0C035                 ; and resave it!
0646 0E3E                       longa on
0647 0E3E C2 20                 rep   #$20                     ; and turn back on long <A>
0648 0E40
0649 0E40 4C EA FB              jmp   BusyEC0
0650 0E43
0651 0E43                       ENDP 
0652 0E43
0653 0E43
0654 0E43
0655 0E43              ****************************************************************
0656 0E43              *
0657 0E43              * CoreVersion
0658 0E43              *
0659 0E43              * Returns the version number.
0660 0E43              *
0661 0E43              *
0662 0E43              * Change History
0663 0E43              *
0664 0E43              * 17 Oct 88	Steven Glass
0665 0E43              *
0666 0E43              * Added call to youve got to be kidding.
0667 0E43              ****************************************************************
0668 0E43              CoreVersion PROC EXPORT 
0669 0E43
0670 0E43                       import YouveGotToBeKidding 
0671 0E43
0672 0E43              RTL1     equ   1
0673 0E43              RTL2     equ   RTL1+3
0674 0E43              V        equ   RTL2+3
0675 0E43
0676 0E43 22 A1 E5 FC           jsl   YouveGotToBeKidding
0677 0E47
0678 0E47 22 14 1F E0           jsl   GimmeVersion
0679 0E4B 83 07                 sta   V,s
0680 0E4D 4C DF FB              jmp   oEndCall0
0681 0E50
0682 0E50                       EXPORT iGimmeVersion 
0683 0E50              iGimmeVersion                           ; 
0684 0E50
0685 0E50 A9 00 03              lda   #TheCoreVersion
0686 0E53 6B                    rtl   
0687 0E54
0688 0E54
0689 0E54                       ENDP 
0690 0E54
0691 0E54              ****************************************************************
0692 0E54              *
0693 0E54              * CoreReset
0694 0E54              *
0695 0E54              * Called when reset	is pressed.  I try to shutdown.
0696 0E54              *
0697 0E54              ****************************************************************
0698 0E54                       EXPORT CoreReset 
0699 0E54              CoreReset PROC 
0700 0E54
0701 0E54 A2 04 03 22           _QDShutDown                    ; shutdown everything
0702 0E5B
0703 0E5B 4C DF FB              jmp   oEndCall0
0704 0E5E
0705 0E5E                       ENDP 
0706 0E5E
0707 0E5E              ****************************************************************
0708 0E5E              *
0709 0E5E              * QDStatus
0710 0E5E              *
0711 0E5E              * Returns TRUE if active, FALSE otherwise.
0712 0E5E              *
0713 0E5E              *
0714 0E5E              ****************************************************************
0715 0E5E                       EXPORT QDStatus 
0716 0E5E              QDStatus PROC 
0717 0E5E              RTL1     equ   1
0718 0E5E              RTL2     equ   RTL1+3
0719 0E5E              TheResult equ   RTL2+3
0720 0E5E
0721 0E5E C9 00 00              cmp   #0
0722 0E61 F0 08                 beq   NotActive
0723 0E63
0724 0E63 A9 FF FF              lda   #TRUE
0725 0E66 83 07        GotIt    sta   TheResult,s
0726 0E68
0727 0E68 4C DF FB              jmp   oEndCall0
0728 0E6B
0729 0E6B A9 00 00     NotActive lda   #False
0730 0E6E 80 F6                 bra   GotIt
0731 0E70
0732 0E70                       ENDP 
0733 0E70
0734 0E70
0735 0E70
0736 0E70
0737 0E70              ;                COPY init/CORE.DATA
0738 0E70                       EXPORT CoreDATA 
0739 0E70              CoreDATA PROC 
0740 0E70
0741 0E70                       EXPORT Port320 
0742 0E70              Port320                                 ; 
0743 0E70                       EXPORT StandardPort 
0744 0E70              StandardPort                            ; 
0745 0E70
0746 0E70                       EXPORT xLocStart 
0747 0E70 00 00        xLocStart DC W:StandardSCB              ; PortSCB
0748 0E72 00 20 E1 00           DC L:$E12000                   ; ImageRef
0749 0E76 A0 00                 DC W:160                       ; Width
0750 0E78 00 00 00 00           DC W:0,0,200,320               ; BoundsRect
0751 0E80                       EXPORT xLocEnd 
0752 0E80              xLocEnd                                 ; 
0753 0E80
0754 0E80 00 00 00 00           DC W:0,0,200,320               ; PortRect
0755 0E88
0756 0E88 00 00 00 00           DC L:0                         ; ClipRef
0757 0E8C 00 00 00 00           DC L:0                         ; VisRef
0758 0E90
0759 0E90 FF                    DC B:$FF                       ; BkPat
0760 0E91 FF                    DC B:$FF
0761 0E92 FF                    DC B:$FF
0762 0E93 FF                    DC B:$FF
0763 0E94 FF                    DC B:$FF
0764 0E95 FF                    DC B:$FF
0765 0E96 FF                    DC B:$FF
0766 0E97 FF                    DC B:$FF
0767 0E98 FF                    DC B:$FF
0768 0E99 FF                    DC B:$FF
0769 0E9A FF                    DC B:$FF
0770 0E9B FF                    DC B:$FF
0771 0E9C FF                    DC B:$FF
0772 0E9D FF                    DC B:$FF
0773 0E9E FF                    DC B:$FF
0774 0E9F FF                    DC B:$FF
0775 0EA0 FF                    DC B:$FF
0776 0EA1 FF                    DC B:$FF
0777 0EA2 FF                    DC B:$FF
0778 0EA3 FF                    DC B:$FF
0779 0EA4 FF                    DC B:$FF
0780 0EA5 FF                    DC B:$FF
0781 0EA6 FF                    DC B:$FF
0782 0EA7 FF                    DC B:$FF
0783 0EA8 FF                    DC B:$FF
0784 0EA9 FF                    DC B:$FF
0785 0EAA FF                    DC B:$FF
0786 0EAB FF                    DC B:$FF
0787 0EAC FF                    DC B:$FF
0788 0EAD FF                    DC B:$FF
0789 0EAE FF                    DC B:$FF
0790 0EAF FF                    DC B:$FF
0791 0EB0
0792 0EB0                       EXPORT StdPnState 
0793 0EB0 00 00 00 00  StdPnState DC W:0,0                     ; PnLoc
0794 0EB4 01 00 01 00           DC W:1,1                       ; PnSize
0795 0EB8 00 00                 DC W:0                         ; PnMode
0796 0EBA 00                    DC B:0                         ; PnPat
0797 0EBB 00                    DC B:0
0798 0EBC 00                    DC B:0
0799 0EBD 00                    DC B:0
0800 0EBE 00                    DC B:0
0801 0EBF 00                    DC B:0
0802 0EC0 00                    DC B:0
0803 0EC1 00                    DC B:0
0804 0EC2 00                    DC B:0
0805 0EC3 00                    DC B:0
0806 0EC4 00                    DC B:0
0807 0EC5 00                    DC B:0
0808 0EC6 00                    DC B:0
0809 0EC7 00                    DC B:0
0810 0EC8 00                    DC B:0
0811 0EC9 00                    DC B:0
0812 0ECA 00                    DC B:0
0813 0ECB 00                    DC B:0
0814 0ECC 00                    DC B:0
0815 0ECD 00                    DC B:0
0816 0ECE 00                    DC B:0
0817 0ECF 00                    DC B:0
0818 0ED0 00                    DC B:0
0819 0ED1 00                    DC B:0
0820 0ED2 00                    DC B:0
0821 0ED3 00                    DC B:0
0822 0ED4 00                    DC B:0
0823 0ED5 00                    DC B:0
0824 0ED6 00                    DC B:0
0825 0ED7 00                    DC B:0
0826 0ED8 00                    DC B:0
0827 0ED9 00                    DC B:0
0828 0EDA FF                    DC B:$FF                       ; PnMask
0829 0EDB FF                    DC B:$FF
0830 0EDC FF                    DC B:$FF
0831 0EDD FF                    DC B:$FF
0832 0EDE FF                    DC B:$FF
0833 0EDF FF                    DC B:$FF
0834 0EE0 FF                    DC B:$FF
0835 0EE1 FF                    DC B:$FF
0836 0EE2                       EXPORT xEndPnState 
0837 0EE2 00 00        xEndPnState DC W:0                      ; PnVis
0838 0EE4
0839 0EE4
0840 0EE4 1B DD FC 00           DC L:SystemFont                ; FontHandle
0841 0EE8 00 00 00 00           DC L:0                         ; FontID
0842 0EEC 00 00                 DC W:0                         ; FontFlags
0843 0EEE 00 00                 DC W:0                         ; TxSize
0844 0EF0 00 00                 DC W:0                         ; TxFace
0845 0EF2 00 00                 DC W:0                         ; TxMode
0846 0EF4 00 00 00 00           DC L:0                         ; SpaceExtra is a fixed pt value
0847 0EF8 00 00 00 00           DC L:0                         ; CharExtra is a fixed pt value
0848 0EFC 00 00                 DC W:0                         ; FGColor
0849 0EFE FF FF                 DC W:$FFFF                     ; BGColor
0850 0F00
0851 0F00 00 00 00 00           DC L:0                         ; PicSave
0852 0F04 00 00 00 00           DC L:0                         ; RgnSave
0853 0F08 00 00 00 00           DC L:0                         ; PolySave
0854 0F0C 00 00 00 00           DC L:0                         ; GrafProcs
0855 0F10
0856 0F10 00 00                 DC W:0                         ; ArcRot
0857 0F12
0858 0F12 00 00 00 00           DC L:0                         ; UserField
0859 0F16
0860 0F16 00 00 00 00           DC L:0                         ; SystemField
0861 0F1A
0862 0F1A                       EXPORT EndStandardPort 
0863 0F1A              EndStandardPort                         ; 
0864 0F1A
0865 0F1A
0866 0F1A                       EXPORT Port640 
0867 0F1A              Port640                                 ; 
0868 0F1A 80 00                 DC W:StandardSCB+$80           ; MasterSCB
0869 0F1C 00 20 E1 00           DC L:$E12000                   ; ImageRef
0870 0F20 A0 00                 DC W:160                       ; Width
0871 0F22 00 00 00 00           DC W:0,0,200,640               ; BoundsRect
0872 0F2A 00 00 00 00           DC W:0,0,200,640               ; PortRect
0873 0F32
0874 0F32
0875 0F32
0876 0F32                       ENDP 
0877 0F32
0878 0F32
0879 0F32
0880 0F32
0881 0F32
0882 0F32                       EXPORT ColorData 
0883 0F32              ColorData PROC 
0884 0F32
0885 0F32              ; This is Annette Wagners subject color table.  Chosen because
0886 0F32              ; she liked the colors.
0887 0F32                       EXPORT Table320 
0888 0F32 00 00        Table320 DC W:$0000                     ; black
0889 0F34 77 07                 DC W:$0777                     ; Dark gray
0890 0F36 41 08                 DC W:$0841                     ; brown
0891 0F38 2C 07                 DC W:$072C                     ; purple
0892 0F3A
0893 0F3A 0F 00                 DC W:$000F                     ; blue
0894 0F3C 80 00                 DC W:$0080                     ; dark green?
0895 0F3E 70 0F                 DC W:$0F70                     ; orange
0896 0F40 00 0D                 DC W:$0D00                     ; red
0897 0F42
0898 0F42 A9 0F                 DC W:$0FA9                     ; flesh
0899 0F44 F0 0F                 DC W:$0FF0                     ; yellow
0900 0F46 E0 00                 DC W:$00E0                     ; green
0901 0F48 DF 04                 DC W:$04DF                     ; light blue
0902 0F4A
0903 0F4A AF 0D                 DC W:$0DAF                     ; light purple or lilac
0904 0F4C 8F 07                 DC W:$078F                     ; periwinkle blue
0905 0F4E CC 0C                 DC W:$0CCC                     ; light gray
0906 0F50 FF 0F                 DC W:$0FFF                     ; white
0907 0F52
0908 0F52                       EXPORT Table640 
0909 0F52 00 00        Table640 DC W:$0000                     ; black
0910 0F54 00 0F                 DC W:$0F00                     ; red
0911 0F56 F0 00                 DC W:$00F0                     ; green
0912 0F58 FF 0F                 DC W:$0FFF                     ; white
0913 0F5A
0914 0F5A 00 00                 DC W:$0000                     ; black
0915 0F5C 0F 00                 DC W:$000F                     ; blue
0916 0F5E F0 0F                 DC W:$0FF0                     ; yellow
0917 0F60 FF 0F                 DC W:$0FFF                     ; white
0918 0F62
0919 0F62 00 00                 DC W:$0000                     ; black
0920 0F64 00 0F                 DC W:$0F00                     ; red
0921 0F66 F0 00                 DC W:$00F0                     ; green
0922 0F68 FF 0F                 DC W:$0FFF                     ; white
0923 0F6A
0924 0F6A 00 00                 DC W:$0000                     ; black
0925 0F6C 0F 00                 DC W:$000F                     ; blue
0926 0F6E F0 0F                 DC W:$0FF0                     ; yellow
0927 0F70 FF 0F                 DC W:$0FFF                     ; white
0928 0F72
0929 0F72
0930 0F72                       ENDP 
0931 0F72
0932 0F72
0933 0F72
0934 0F72
0935 0F72
0936 0F72
0937 0F72
0938 0F72                       EXPORT QDProcs 
0939 0F72              QDProcs  PROC 
0940 0F72                       EXPORT Here 
0941 0F72              Here                                    ; 
0942 0F72
0943 0F72 03 1E E0 00           DC L:StdText-1
0944 0F76 07 1E E0 00           DC L:StdLine-1
0945 0F7A 0B 1E E0 00           DC L:StdRect-1
0946 0F7E 0F 1E E0 00           DC L:StdRRect-1
0947 0F82 13 1E E0 00           DC L:StdOval-1
0948 0F86 17 1E E0 00           DC L:StdArc-1
0949 0F8A 1B 1E E0 00           DC L:StdPoly-1
0950 0F8E 1F 1E E0 00           DC L:StdRgn-1
0951 0F92 23 1E E0 00           DC L:StdPixels-1
0952 0F96 27 1E E0 00           DC L:StdComment-1
0953 0F9A 2B 1E E0 00           DC L:StdTxMeas-1
0954 0F9E 2F 1E E0 00           DC L:StdTxBnds-1
0955 0FA2 33 1E E0 00           DC L:StdGetPic-1
0956 0FA6 37 1E E0 00           DC L:StdPutPic-1
0957 0FAA
0958 0FAA
0959 0FAA                       ENDP 
0960 0FAA
0961 0FAA
0962 0FAA
0963 0FAA              ;                copy init/adv.stuff
0964 0FAA              ****************************************************************
0965 0FAA              *
0966 0FAA              * QDStart
0967 0FAA              *
0968 0FAA              * This is a local routine that increments the busy flag, saves
0969 0FAA              * the current direct register on the stack and transfers
0970 0FAA              * the a register to the D register.
0971 0FAA              *
0972 0FAA              * This is meant to be called at the start of any QD entry point
0973 0FAA              * that requires zero page and the busy flag to be incremented.
0974 0FAA              *
0975 0FAA              * In Doing this we trash the X-Register.  Hopefully this will
0976 0FAA              * not cause anyone any problems.
0977 0FAA              *
0978 0FAA              * We do know that A and Y must be untouched.  Y for PortWord
0979 0FAA              * and PortLong.  A for cursor routines that add $100 to A
0980 0FAA              *
0981 0FAA              * 2/27/89	Mensch and Konstantine
0982 0FAA              *
0983 0FAA              * Squeeze just a few more bytes/cycles out of qdstart
0984 0FAA              *
0985 0FAA              ****************************************************************
0986 0FAA                       EXPORT QDStart 
0987 0FAA              QDStart  PROC 
0988 0FAA
0989 0FAA 48                    pha   
0990 0FAB AF FF 00 E1           lda   >BusyFlag
0991 0FAF 1A                    inc   a
0992 0FB0 8F FF 00 E1           sta   >BusyFlag
0993 0FB4 68                    pla   
0994 0FB5 0B                    phd                            ; push d on stack
0995 0FB6 5B                    tcd                            ; set d
0996 0FB7 A3 03                 lda   3,s                      ; getorig rts
0997 0FB9 48                    pha                            ; put on stack
0998 0FBA A3 03                 lda   3,s                      ; move orig d to on top of rts
0999 0FBC 83 05                 sta   5,s
1000 0FBE 68                    pla                            ; pull rts off stack
1001 0FBF 83 01                 sta   1,s                      ; put over orig d
1002 0FC1 7B                    tdc                            ; get QD D back in a
1003 0FC2 60                    rts                            ; done
1004 0FC3
1005 0FC3                       ENDP 
1006 0FC3
1007 0FC3
1008 0FC3
1009 0FC3
1010 0FC3
1011 0FC3
1012 0FC3              ****************************************************************
1013 0FC3              *
1014 0FC3              * TestGPs
1015 0FC3              *
1016 0FC3              * Internal routine to move the point to the grafprocs to
1017 0FC3              * zero page.  If this pointer is zero, then the carry
1018 0FC3              * returns clear.  If the pointer is nonzero, the carry
1019 0FC3              * returns set.
1020 0FC3              *
1021 0FC3              * 15 March 89	Mensch
1022 0FC3              *
1023 0FC3              * Shave a few more cycles out.!
1024 0FC3              *
1025 0FC3              ****************************************************************
1026 0FC3                       EXPORT TestGPs 
1027 0FC3              TestGPs  PROC 
1028 0FC3
1029 0FC3 DA                    phx   
1030 0FC4 A0 9C 00              ldy   #o_grafprocs
1031 0FC7 B7 24                 lda   [PortRef],y
1032 0FC9 AA                    tax   
1033 0FCA A0 9E 00              ldy   #o_grafprocs+2
1034 0FCD 17 24                 ora   [PortRef],y
1035 0FCF F0 09                 beq   IsZero
1036 0FD1 86 2A                 stx   temp
1037 0FD3 B7 24                 lda   [PortRef],y
1038 0FD5 85 2C                 sta   temp+2
1039 0FD7 38                    sec   
1040 0FD8 FA                    plx   
1041 0FD9 60                    rts   
1042 0FDA
1043 0FDA              IsZero    
1044 0FDA A2 00 02              ldx   #512
1045 0FDD B5 EC                 lda   <DirtyDPFlags,x
1046 0FDF 09 10 00              ora   #NoUserGrafProcs
1047 0FE2 95 EC                 sta   <DirtyDPFlags,x
1048 0FE4 FA                    plx   
1049 0FE5 18                    clc   
1050 0FE6 60                    rts   
1051 0FE7
1052 0FE7                       ENDP 
1053 0FE7
1054 0FE7
1055 0FE7
1056 0FE7
1057 0FE7              ****************************************************************
1058 0FE7              *
1059 0FE7              * PutPictStuff
1060 0FE7              *
1061 0FE7              ****************************************************************
1062 0FE7                       EXPORT iPutPictStuff 
1063 0FE7              iPutPictStuff PROC 
1064 0FE7
1065 0FE7 DA                    phx   
1066 0FE8 A2 00 02              ldx   #512
1067 0FEB B5 EC                 lda   <DirtyDPFlags,x
1068 0FED 09 02 00              ora   #NoPictRecord
1069 0FF0 95 EC                 sta   <DirtyDPFlags,x
1070 0FF2 FA                    plx   
1071 0FF3 18                    clc   
1072 0FF4 A9 00 00              lda   #0
1073 0FF7 6B                    rtl   
1074 0FF8
1075 0FF8                       ENDP 
1076 0FF8
1077 0FF8
1078 0FF8
1079 0FF8
1080 0FF8              ****************************************************************
1081 0FF8              *
1082 0FF8              * SetStdProcs     (ProcPtr : Ptr);
1083 0FF8              *
1084 0FF8              * Sets the record containing pointers to standard procs to
1085 0FF8              * point to all the standard procs in ROM.
1086 0FF8              *
1087 0FF8              ****************************************************************
1088 0FF8                       EXPORT SetStdProcs 
1089 0FF8              SetStdProcs PROC 
1090 0FF8              RTL1     equ   1
1091 0FF8              RTL2     equ   RTL1+3
1092 0FF8              ProcPtr  equ   RTL2+3
1093 0FF8
1094 0FF8 3B                    tsc                            ; get stack
1095 0FF9 0B                    phd                            ; save direct
1096 0FFA 5B                    tcd                            ; set direct to stack
1097 0FFB
1098 0FFB A0 36 00              ldy   #QDProcSize-2
1099 0FFE BB           Loop     tyx   
1100 0FFF BF 72 0F FE           lda   >QDProcs,x
1101 1003 97 07                 sta   [ProcPtr],y
1102 1005 88                    dey   
1103 1006 88                    dey   
1104 1007 10 F5                 bpl   Loop
1105 1009
1106 1009 4C 0E FC              jmp   EndCall4
1107 100C
1108 100C                       ENDP 
1109 100C
1110 100C
1111 100C
1112 100C              *****************************************************************
1113 100C              *
1114 100C              * WideOpen
1115 100C              *
1116 100C              * This is the default clipping region
1117 100C              *
1118 100C              *****************************************************************
1119 100C                       EXPORT WideOpen 
1120 100C              WideOpen PROC 
1121 100C
1122 100C 12 10 FE 00           DC L:TheRegion
1123 1010 00 00                 DS B:2                         ; safety for locking
1124 1012 0A 00        TheRegion DC W:10
1125 1014 01 C0 01 C0           DC W:-32767/2,-32767/2,32767/2,32767/2
1126 101C
1127 101C                       ENDP 
1128 101C
1129 101C
1130 101C              ****************************************************************
1131 101C              *
1132 101C              * GetAddress
1133 101C              *
1134 101C              *            space for result   long
1135 101C              *            id number          word
1136 101C              *
1137 101C              *
1138 101C              ****************************************************************
1139 101C                       EXPORT GetAddress 
1140 101C              GetAddress PROC 
1141 101C
1142 101C                       import ScreenTable 
1143 101C                       import ConTable320 
1144 101C                       import ConTable640 
1145 101C
1146 101C
1147 101C              RTL1     equ   1
1148 101C              RTL2     equ   RTL1+3
1149 101C              IDNumber equ   RTL2+3
1150 101C              ResultSpace equ   IDNumber+2
1151 101C
1152 101C
1153 101C A3 07                 lda   IDNumber,s
1154 101E 29 FF 00              and   #$00FF
1155 1021 0A                    asl   a
1156 1022 0A                    asl   a
1157 1023 AA                    tax   
1158 1024
1159 1024 BF 2F 10 FE           lda   >MyTable-4,x
1160 1028 83 09                 sta   ResultSpace,s
1161 102A BF 31 10 FE           lda   >MyTable-4+2,x
1162 102E 83 0B                 sta   ResultSpace+2,s
1163 1030
1164 1030 4C F7 FB              jmp   oEndCall2
1165 1033
1166 1033              MyTable                                 ; 
1167 1033 3C 55 FE 00           DC L:ScreenTable
1168 1037 72 63 FE 00           DC L:ConTable320
1169 103B 72 67 FE 00           DC L:ConTable640
1170 103F
1171 103F                       ENDP 
1172 103F
1173 103F
1174 103F              ****************************************************************
1175 103F              *
1176 103F              * SetSysFont
1177 103F              *
1178 103F              * Change History
1179 103F              *
1180 103F              * 21 Aug 86    SEG	   This forgot to phd and set tcd so zp
1181 103F              *	   was never right.  Moreover stack was
1182 103F              *	   trashed on way out.
1183 103F              *
1184 103F              ****************************************************************
1185 103F                       EXPORT SetSysFont 
1186 103F              SetSysFont PROC 
1187 103F              OrigDirect equ   1
1188 103F              RTL1     equ   OrigDirect+2
1189 103F              RTL2     equ   RTL1+3
1190 103F              FontHandle equ   RTL2+3
1191 103F
1192 103F 20 AA 0F              jsr   QDStart
1193 1042
1194 1042 A2 00 01              ldx   #256
1195 1045 A3 09                 lda   FontHandle,s
1196 1047 95 4E                 sta   SysFont,x
1197 1049 A3 0B                 lda   FontHandle+2,s
1198 104B 95 50                 sta   SysFont+2,x
1199 104D
1200 104D 4C 19 FC              jmp   BusyEC4
1201 1050
1202 1050
1203 1050                       ENDP 
1204 1050
1205 1050              ****************************************************************
1206 1050              *
1207 1050              * GetSysFont
1208 1050              *
1209 1050              ****************************************************************
1210 1050                       EXPORT GetSysFont 
1211 1050              GetSysFont PROC 
1212 1050              OrigDirect equ   1
1213 1050              RTL1     equ   OrigDirect+2
1214 1050              RTL2     equ   RTL1+3
1215 1050              ResultHandle equ   RTL2+3
1216 1050
1217 1050
1218 1050 20 AA 0F              jsr   QDStart
1219 1053
1220 1053 A2 00 01              ldx   #256
1221 1056 B5 4E                 lda   SysFont,x
1222 1058 83 09                 sta   ResultHandle,s
1223 105A B5 50                 lda   SysFont+2,x
1224 105C 83 0B                 sta   ResultHandle+2,s
1225 105E
1226 105E 4C EA FB              jmp   BusyEC0
1227 1061
1228 1061
1229 1061                       ENDP 
1230 1061
1231 1061
1232 1061              ****************************************************************
1233 1061              *
1234 1061              * SetBufDims
1235 1061              *
1236 1061              *        MaxWidth : integer
1237 1061              *        MaxFontHeight : integer
1238 1061              *        MaxFontWidth : integer
1239 1061              *
1240 1061              * This routine forces the resizing of all of QuickDraw's
1241 1061              * internal buffers: the ClipBuffer and the text buffer.
1242 1061              *
1243 1061              * Modification History
1244 1061              *
1245 1061              * May 9, 1986    This used to be SetMaxWidth and there separate
1246 1061              *                text buffer sizing calls.  Since the two are
1247 1061              *                interrelated, it is now one call.
1248 1061              *
1249 1061              ****************************************************************
1250 1061                       EXPORT SetBufDims 
1251 1061              SetBufDims PROC 
1252 1061
1253 1061              OrigDirect equ   1
1254 1061              RTL1     equ   OrigDirect+2
1255 1061              RTL2     equ   RTL1+3
1256 1061              sMaxFontWidth equ   RTL2+3
1257 1061              sMaxFontHeight equ   sMaxFontWidth+2
1258 1061              sMaxWidth equ   sMaxFontHeight+2
1259 1061
1260 1061 20 AA 0F              jsr   QDStart
1261 1064
1262 1064 64 56                 stz   ForcedFont               ; zero the indicator of force
1263 1066
1264 1066                       EXPORT JoinBufStuff 
1265 1066              JoinBufStuff                            ; 
1266 1066
1267 1066 A3 0D                 lda   sMaxWidth,s
1268 1068
1269 1068 20 6E 0D              jsr   CalcClipSize
1270 106B
1271 106B F4 00 00              pea   0
1272 106E 48                    pha   
1273 106F D4 3E                 pei   BufferHandle+2
1274 1071 D4 3C                 pei   BufferHandle
1275 1073 A2 02 19 22           _SetHandleSize 
1276 107A
1277 107A 90 04                 bcc   noerror1
1278 107C AA           AnError  tax   
1279 107D 4C 32 FC              jmp   BusyErr6
1280 1080
1281 1080 A3 0D        noerror1 lda   sMaxWidth,s
1282 1082 85 28                 sta   MaxWidth
1283 1084
1284 1084 A3 09                 lda   sMaxFontWidth,s
1285 1086 85 52                 sta   NewMaxFontWidth
1286 1088 A3 0B                 lda   sMaxFontHeight,s
1287 108A 85 50                 sta   NewTBHeight
1288 108C
1289 108C 22 A8 1F E0           jsl   SetTB
1290 1090 B0 EA                 bcs   AnError
1291 1092
1292 1092 A3 0D                 lda   sMaxWidth,s
1293 1094 85 28                 sta   MaxWidth
1294 1096
1295 1096 4C 2F FC              jmp   BusyEC6
1296 1099
1297 1099                       ENDP 
1298 1099
1299 1099              ****************************************************************
1300 1099              *
1301 1099              * ForceBufDims
1302 1099              *
1303 1099              *        MaxWidth : integer
1304 1099              *        MaxFontHeight : integer
1305 1099              *        MaxFontWidth : integer
1306 1099              *
1307 1099              * This routine forces the resizing of all of QuickDraw's
1308 1099              * internal buffers: the ClipBuffer and the text buffer.
1309 1099              * The text buffer sizing is done as force.
1310 1099              *
1311 1099              * Modification History
1312 1099              *
1313 1099              * May 9, 1986    See notes above
1314 1099              *
1315 1099              ****************************************************************
1316 1099                       EXPORT ForceBufDims 
1317 1099              ForceBufDims PROC 
1318 1099
1319 1099 20 AA 0F              jsr   QDStart
1320 109C
1321 109C A9 00 80              lda   #$8000
1322 109F 85 56                 sta   ForcedFont
1323 10A1
1324 10A1 80 C3                 bra   JoinBufStuff
1325 10A3
1326 10A3                       ENDP 
1327 10A3
1328 10A3
1329 10A3
1330 10A3
1331 10A3              ****************************************************************
1332 10A3              *
1333 10A3              * SaveBufDims
1334 10A3              *
1335 10A3              *     TBRecPtr    pointer
1336 10A3              *
1337 10A3              * 8 bytes of information on sizing the quick draw text buffers
1338 10A3              * is moved from here to the users buffer.  This information
1339 10A3              * can restore the current state when passed back with
1340 10A3              * RestoreBufDims
1341 10A3              *
1342 10A3              ****************************************************************
1343 10A3                       EXPORT SaveBufDims 
1344 10A3              SaveBufDims PROC 
1345 10A3
1346 10A3              OrigDirect equ   1
1347 10A3              RTL1     equ   OrigDirect+2
1348 10A3              RTL2     equ   RTL1+3
1349 10A3              TBRecPtr equ   RTL2+3
1350 10A3
1351 10A3 20 AA 0F              jsr   QDStart
1352 10A6
1353 10A6 A3 09                 lda   TBRecPtr,s
1354 10A8 85 2A                 sta   temp
1355 10AA A3 0B                 lda   TBRecPtr+2,s
1356 10AC 85 2C                 sta   temp+2
1357 10AE
1358 10AE A5 28                 lda   MaxWidth                 ; first put the MaxWidth
1359 10B0 87 2A                 sta   [temp]
1360 10B2
1361 10B2 A5 4A                 lda   textBufHeight            ; second the text buf height
1362 10B4 A0 02 00              ldy   #2
1363 10B7 97 2A                 sta   [temp],y
1364 10B9
1365 10B9 A5 48                 lda   textBufRowWords          ; next the textBufRowWords
1366 10BB C8                    iny   
1367 10BC C8                    iny   
1368 10BD 97 2A                 sta   [temp],y
1369 10BF
1370 10BF A2 00 01              ldx   #256                     ; finally the FontWidth from
1371 10C2 B5 04                 lda   FontWidth,x              ; second zero page.
1372 10C4 C8                    iny   
1373 10C5 C8                    iny   
1374 10C6 97 2A                 sta   [temp],y
1375 10C8
1376 10C8 4C 19 FC              jmp   BusyEC4
1377 10CB
1378 10CB
1379 10CB                       ENDP 
1380 10CB
1381 10CB
1382 10CB              ****************************************************************
1383 10CB              *
1384 10CB              * RestoreBufDims
1385 10CB              *
1386 10CB              *     TBRecPtr    pointer
1387 10CB              *
1388 10CB              * Using 8 bytes of information in the record pointed to above,
1389 10CB              * QuickDraw resizes	its buffers.
1390 10CB              *
1391 10CB              * The eight bytes are arranged as follows:
1392 10CB              *
1393 10CB              *       MaxWidth
1394 10CB              *       TextBufHeight
1395 10CB              *       TextBufRowWords
1396 10CB              *       FontWidth
1397 10CB              *
1398 10CB              ****************************************************************
1399 10CB                       EXPORT RestoreBufDims 
1400 10CB              RestoreBufDims PROC 
1401 10CB
1402 10CB
1403 10CB              OrigDirect equ   1
1404 10CB              RTL1     equ   OrigDirect+2
1405 10CB              RTL2     equ   RTL1+3
1406 10CB              TBRecPtr equ   RTL2+3
1407 10CB
1408 10CB 20 AA 0F              jsr   QDStart
1409 10CE
1410 10CE A3 09                 lda   TBRecPtr,s
1411 10D0 85 2A                 sta   temp
1412 10D2 A3 0B                 lda   TBRecPtr+2,s
1413 10D4 85 2C                 sta   temp+2
1414 10D6
1415 10D6 A7 2A                 lda   [temp]                   ; using MaxWidth, calc the
1416 10D8 20 6E 0D              jsr   CalcClipSize             ; right buffer size.
1417 10DB
1418 10DB F4 00 00              pea   0                        ; resize the handle
1419 10DE 48                    pha   
1420 10DF D4 3E                 pei   BufferHandle+2
1421 10E1 D4 3C                 pei   BufferHandle
1422 10E3 A2 02 19 22           _SetHandleSize 
1423 10EA 90 04                 bcc   NoError1
1424 10EC
1425 10EC AA                    tax                            ; an error occured so quit
1426 10ED 4C 1C FC              jmp   BusyErr4
1427 10F0
1428 10F0              NoError1                                ; 
1429 10F0
1430 10F0              ;----------------------------------------------------
1431 10F0              ;
1432 10F0              ; Now put the working MaxWidth on ZP and
1433 10F0              ; resize the text buffer.
1434 10F0              ;
1435 10F0 A7 2A                 lda   [temp]                   ; get the MaxWidth
1436 10F2 85 28                 sta   MaxWidth
1437 10F4
1438 10F4 A0 02 00              ldy   #2                       ; get the textBufHeight
1439 10F7 B7 2A                 lda   [temp],y
1440 10F9 85 50                 sta   NewTBHeight
1441 10FB
1442 10FB C8                    iny                            ; get the textBufRowWords
1443 10FC C8                    iny   
1444 10FD B7 2A                 lda   [temp],y
1445 10FF 85 54                 sta   NewTBRowWords
1446 1101
1447 1101 C8                    iny                            ; get the FontWidth indicator
1448 1102 C8                    iny   
1449 1103 B7 2A                 lda   [temp],y
1450 1105 85 56                 sta   NewFontWidth
1451 1107
1452 1107 22 AC 1F E0           jsl   ResetTB                  ; this call changes the text buffer
1453 110B 90 04                 bcc   NoError2                 ; and sets the params if successful
1454 110D
1455 110D AA                    tax                            ; return the error and don't
1456 110E 4C 1C FC              jmp   BusyErr4
1457 1111
1458 1111
1459 1111 4C 19 FC     NoError2 jmp   BusyEC4
1460 1114
1461 1114
1462 1114
1463 1114
1464 1114                       ENDP 
1465 1114
1466 1114
1467 1114
1468 1114              E0Vectors PROC 
1469 1114
1470 1114                       ENTRY TheE0Vstart 
1471 1114              TheE0Vstart                             ; 
1472 1114
1473 1114
1474 1114 5C 00 00 00           jml   >$000000                 ; toStuff
1475 1118
1476 1118 5C 66 7D FE           jml   iStdText
1477 111C 5C 6D 35 FE           jml   iStdLine
1478 1120 5C F6 2F FE           jml   iStdRect
1479 1124 5C BF 96 FE           jml   iStdRRect
1480 1128 5C BA 96 FE           jml   iStdOval
1481 112C 5C B5 96 FE           jml   iStdArc
1482 1130 5C 9B A1 FE           jml   iStdPoly
1483 1134 5C 23 57 FE           jml   iStdRgn
1484 1138 5C 2B 44 FE           jml   iStdPixels
1485 113C 5C D9 FB FE           jml   NotImp
1486 1140 5C B7 7C FE           jml   iStdTxMeas
1487 1144 5C 52 84 FE           jml   iStdTxBnds
1488 1148 5C D9 FB FE           jml   NotImp
1489 114C 5C D9 FB FE           jml   NotImp
1490 1150
1491 1150
1492 1150 5C 9B 1D FE           jml   iPortLoc2ZP
1493 1154 5C F9 1D FE           jml   iUserPat2ZP
1494 1158 5C 3B 1E FE           jml   iGetPenPReady
1495 115C 5C 6E 1E FE           jml   iGetBackPReady
1496 1160 5C A1 1E FE           jml   iPen2ZP
1497 1164 5C E4 1E FE           jml   iBack2ZP
1498 1168 5C 4F 1F FE           jml   iRotatePat
1499 116C 5C BD 1F FE           jml   iGetMaskReady
1500 1170 5C 2E 20 FE           jml   iMask2ZP
1501 1174 5C 42 20 FE           jml   iExpandMask
1502 1178 5C A5 20 FE           jml   iRotatemask
1503 117C 5C 0F 21 FE           jml   iRotateLong
1504 1180 5C F9 2D FE           jml   iPreDraw
1505 1184 5C 1A 2E FE           jml   iXSetup
1506 1188
1507 1188 5C C6 30 FE           jml   iDrawRectB
1508 118C 5C D0 30 FE           jml   iDrawRect
1509 1190 5C 0D 4A FE           jml   iSliceSetup
1510 1194                                                      ; these are not used internally!
1511 1194 5C E3 4B FE           jml   ShiftStay                ; because I don't want to slow
1512 1198                                                      ; things down.  They are provide
1513 1198 5C E5 4B FE           jml   XShiftStay               ; so that outside routines can use them
1514 119C 5C 6E 4C FE           jml   ShiftOut
1515 11A0 5C 70 4C FE           jml   XShiftOut
1516 11A4
1517 11A4 5C FC 4C FE           jml   iBMakeMinRect
1518 11A8 5C FF 4C FE           jml   iMakeMinRect
1519 11AC 5C EF 51 FE           jml   iShieldCursor
1520 11B0 5C 5D 52 FE           jml   iUnShieldCursor
1521 11B4 5C 7E 5B FE           jml   iSetUpPortRegions
1522 11B8 5C 0A 5C FE           jml   iSetUpScanPtrs
1523 11BC 5C D1 5B FE           jml   iFreePortRegions
1524 11C0 5C C9 5B FE           jml   iFree1Region
1525 11C4 5C C6 5B FE           jml   iFree2Regions
1526 11C8 5C C3 5B FE           jml   iFree3Regions
1527 11CC                                                      ; changed 10 Mar 87 SEG (used to be
1528 11CC 5C B9 85 FE           jml   iGetFGS                  ; UnlockBufferHandle--who knows why?)
1529 11D0 5C DC 5D FE           jml   iInit1Region
1530 11D4 5C 67 5D FE           jml   iInit2Regions
1531 11D8 5C 63 5C FE           jml   iInit3Regions
1532 11DC 5C 07 5E FE           jml   iSeek1Region
1533 11E0 5C AE 5D FE           jml   iSeek2Regions
1534 11E4 5C 29 5D FE           jml   iSeek3Regions
1535 11E8 5C 39 5E FE           jml   iInitRgn
1536 11EC 5C 02 60 FE           jml   iSeekRgn
1537 11F0 5C E6 62 FE           jml   iJoin1Buffer
1538 11F4 5C B9 62 FE           jml   iJoin2Buffers
1539 11F8 5C 88 62 FE           jml   iJoin3Buffers
1540 11FC
1541 11FC 5C 92 2D FE           jml   iSetSlabAdr
1542 1200 5C 0B 4B FE           jml   iSetSliceAdr
1543 1204 5C E0 92 FE           jml   iSetStuffAdr
1544 1208
1545 1208
1546 1208 5C 1D 91 FE           jml   iBlowItUp
1547 120C
1548 120C 5C E7 0F FE           jml   iPutPictStuff
1549 1210 5C D0 A4 FE           jml   iAddToPoly
1550 1214
1551 1214 5C 10 13 FE           jml   iOpenPicture
1552 1218 5C 13 13 FE           jml   iPicComment
1553 121C 5C 16 13 FE           jml   iClosePicture
1554 1220 5C 19 13 FE           jml   iDrawPicture
1555 1224 5C 1C 13 FE           jml   iKillPicture
1556 1228
1557 1228 5C 50 0E FE           jml   iGimmeVersion
1558 122C
1559 122C 5C 77 57 FE           jml   FrRgn
1560 1230 5C 70 57 FE           jml   PRgn
1561 1234 5C 70 57 FE           jml   ERgn
1562 1238 5C 70 57 FE           jml   IRgn
1563 123C 5C 70 57 FE           jml   FRgn
1564 1240 5C 1D 30 FE           jml   FrRect
1565 1244 5C 15 30 FE           jml   PRect
1566 1248 5C 15 30 FE           jml   ERect
1567 124C 5C 15 30 FE           jml   IRect
1568 1250 5C 15 30 FE           jml   FRect
1569 1254
1570 1254
1571 1254 5C 7A 7D FE           jml   iDChar
1572 1258 5C E1 81 FE           jml   iDText
1573 125C 5C 5F 84 FE           jml   iBChar
1574 1260 5C D8 84 FE           jml   iBText
1575 1264 5C B6 87 FE           jml   iValidChar
1576 1268 5C 6D 88 FE           jml   iGetNextChar
1577 126C 5C AF 88 FE           jml   iCalcDrawStatus
1578 1270 5C 11 89 FE           jml   iTextAndMinRect
1579 1274 5C 62 89 FE           jml   iCalcTextBounds
1580 1278 5C EE 89 FE           jml   iSetUpFontInfo
1581 127C 5C FB 8B FE           jml   iSetUpBufInfo
1582 1280 5C 44 8C FE           jml   iGetTextHandle
1583 1284 5C 72 8C FE           jml   iClearBufPart
1584 1288 5C E9 8E FE           jml   iPutChar
1585 128C 5C 9C 88 FE           jml   iBumpPen
1586 1290 5C BB 8C FE           jml   iCleanUpBuffer
1587 1294
1588 1294
1589 1294 5C D5 6B FE           jml   iPutLine
1590 1298 5C 37 6D FE           jml   iPutRgn
1591 129C 5C 73 6B FE           jml   iPutRect
1592 12A0 5C 20 6E FE           jml   iCullPoints
1593 12A4 5C D4 6E FE           jml   iSortPoints
1594 12A8 5C DB 6F FE           jml   iPackRgn
1595 12AC 5C 11 74 FE           jml   iRgnOp
1596 12B0
1597 12B0 5C 64 A0 FE           jml   iPutOval
1598 12B4 5C 21 9B FE           jml   iBumpOval
1599 12B8 5C 57 9A FE           jml   iInitOval
1600 12BC
1601 12BC 5C 4A 90 FE           jml   iSetTB
1602 12C0 5C CC 90 FE           jml   iResetTB
1603 12C4
1604 12C4 5C D6 8C FE           jml   iStyleText
1605 12C8 5C DA 8C FE           jml   iStyleExtents
1606 12CC 5C F8 8C FE           jml   iDoBold
1607 12D0 5C 9D 8D FE           jml   iDoUnderLine
1608 12D4
1609 12D4 5C C2 96 FE           jml   iStdConic
1610 12D8 5C 25 9C FE           jml   iDrawConic
1611 12DC 5C ED 7A FE           jml   iSetScaleAndMap
1612 12E0 5C 93 53 FE           jml   iDrawCursor
1613 12E4 5C B6 54 FE           jml   iUndrawCursor
1614 12E8 5C BD 98 FE           jml   iAngleFromSlope
1615 12EC 5C 06 99 FE           jml   iSlopeFromAngle
1616 12F0
1617 12F0 5C 41 44 FE           jml   iRgnBlt
1618 12F4 5C 2F 46 FE           jml   iSharedMRSetup
1619 12F8 5C A0 46 FE           jml   iShareShieldStuff
1620 12FC
1621 12FC 5C 11 88 FE           jml   iGetCharVals
1622 1300 5C 2F 88 FE           jml   iDoFntFlgMods
1623 1304 5C 4C 88 FE           jml   iAddExtras
1624 1308 5C 90 83 FE           jml   iCalcSlop
1625 130C
1626 130C 5C 89 85 FE           jml   iGetFntInf
1627 1310
1628 1310                       Entry TheE0Vend 
1629 1310              TheE0VEnd  
1630 1310
1631 1310
1632 1310                       ENDP 
1633 1310
1634 1310
1635 1310
1636 1310
1637 1310              ;                copy init/pictures
1638 1310              ****************************************************************
1639 1310              *
1640 1310              * OpenPicture
1641 1310              *
1642 1310              *       space for output   PicHandle : long
1643 1310              *                          PicFrame  : long
1644 1310              *
1645 1310              *
1646 1310              ****************************************************************
1647 1310                       EXPORT iOpenPicture 
1648 1310              iOpenPicture PROC 
1649 1310 4C 0D FC              jmp   oEndCall4
1650 1313                       ENDP 
1651 1313
1652 1313
1653 1313              ****************************************************************
1654 1313              *
1655 1313              * PicComment
1656 1313              *
1657 1313              *       Kind     : word
1658 1313              *       size     : word
1659 1313              *       datahandle : handle
1660 1313              *
1661 1313              ****************************************************************
1662 1313                       EXPORT iPicComment 
1663 1313              iPicComment PROC 
1664 1313 4C 39 FC              jmp   oEndCall8
1665 1316                       ENDP 
1666 1316
1667 1316
1668 1316              ****************************************************************
1669 1316              *
1670 1316              * ClosePicture
1671 1316              *
1672 1316              ****************************************************************
1673 1316                       EXPORT iClosePicture 
1674 1316              iClosePicture PROC 
1675 1316 4C DF FB              jmp   oEndCall0
1676 1319                       ENDP 
1677 1319
1678 1319
1679 1319              ****************************************************************
1680 1319              *
1681 1319              * DrawPicture
1682 1319              *
1683 1319              *            Pic      : PicHandle
1684 1319              *            DestRect : rectPtr  
1685 1319              *
1686 1319              ****************************************************************
1687 1319                       EXPORT iDrawPicture 
1688 1319              iDrawPicture PROC 
1689 1319 4C 39 FC              jmp   oEndCall8
1690 131C                       ENDP 
1691 131C
1692 131C
1693 131C              ****************************************************************
1694 131C              *
1695 131C              * KillPicture
1696 131C              *
1697 131C              *        PicHandle : handle
1698 131C              *
1699 131C              ****************************************************************
1700 131C                       EXPORT iKillPicture 
1701 131C              iKillPicture PROC 
1702 131C 4C 0D FC              jmp   oEndCall4
1703 131F                       ENDP 
1704 131F              ;                copy init/glue
1705 131F              ****************************************************************
1706 131F              *
1707 131F              * NewHandleGlue
1708 131F              *
1709 131F              * This small routine makes the new handle call in a way that
1710 131F              * saves space.
1711 131F              *
1712 131F              ****************************************************************
1713 131F                       EXPORT NewHandleGlue 
1714 131F              NewHandleGlue PROC 
1715 131F
1716 131F A2 02 09              ldx   #$0902
1717 1322
1718 1322                       EXPORT ToGlueEntry 
1719 1322              ToGlueEntry                             ; 
1720 1322 22 04 00 E1           jsl   $E10004
1721 1326 6B                    rtl   
1722 1327
1723 1327                       ENDP 
1724 1327
1725 1327
1726 1327
1727 1327              ****************************************************************
1728 1327              *
1729 1327              * DisposeHandleGlue
1730 1327              *
1731 1327              * This small routine sets up the X-register and branches to
1732 1327              * the "ToGlueEntry" point above.
1733 1327              *
1734 1327              ****************************************************************
1735 1327                       EXPORT DisposeHandleGlue 
1736 1327              DisposeHandleGlue PROC 
1737 1327
1738 1327 A2 02 10              ldx   #$1002
1739 132A 80 F6                 bra   ToGlueEntry
1740 132C
1741 132C
1742 132C                       ENDP 
1743 132C
1744 132C
1745 132C              ****************************************************************
1746 132C              *
1747 132C              * CopyRgnGlue
1748 132C              *
1749 132C              * This small routine sets up the X-register and branches to
1750 132C              * the "ToGlueEntry" point above.
1751 132C              *
1752 132C              ****************************************************************
1753 132C                       EXPORT CopyRgnGlue 
1754 132C              CopyRgnGlue PROC 
1755 132C
1756 132C A2 04 69              ldx   #$6904
1757 132F 80 F1                 bra   ToGlueEntry
1758 1331
1759 1331
1760 1331                       ENDP 
1761 1331
1762 1331              ****************************************************************
1763 1331              *
1764 1331              * SetVectorGlue
1765 1331              *
1766 1331              * This small routine sets up the X-register and branches to
1767 1331              * the "ToGlueEntry" point above.
1768 1331              *
1769 1331              ****************************************************************
1770 1331                       EXPORT SetVectorGlue 
1771 1331              SetVectorGlue PROC 
1772 1331
1773 1331 A2 03 10              ldx   #$1003
1774 1334 80 EC                 bra   ToGlueEntry
1775 1336
1776 1336
1777 1336                       ENDP 
1778 1336
1779 1336
1780 1336              ****************************************************************
1781 1336              *
1782 1336              * GetVectorGlue
1783 1336              *
1784 1336              * This small routine sets up the X-register and branches to
1785 1336              * the "ToGlueEntry" point above.
1786 1336              *
1787 1336              ****************************************************************
1788 1336                       EXPORT GetVectorGlue 
1789 1336              GetVectorGlue PROC 
1790 1336
1791 1336 A2 03 11              ldx   #$1103
1792 1339 80 E7                 bra   ToGlueEntry
1793 133B
1794 133B
1795 133B                       ENDP 
1796 133B
1797 133B
1798 133B
1799 133B
1800 133B
1801 133B              *****************************************************************
1802 133B              *
1803 133B              * SpecialNewHandle
1804 133B              *
1805 133B              * Routine to call to get new handle with
1806 133B              *
1807 133B              *    size         passed in a-reg
1808 133B              *    userid       passed in x-reg
1809 133B              *    attributes   passed in y-reg
1810 133B              *
1811 133B              * Handle is returned in X & Y register (x has low word)
1812 133B              * unless error occurs where x & y are undifined.
1813 133B              *
1814 133B              * For no error a-reg has 0 and carry is clear.  If error occurs
1815 133B              * a-reg has error and carry is set.
1816 133B              *
1817 133B              *****************************************************************
1818 133B                       EXPORT SpecialNewHandle 
1819 133B              SpecialNewHandle PROC 
1820 133B
1821 133B 48                    pha                            ; space for result
1822 133C 48                    pha   
1823 133D F4 00 00              pea   0                        ; high word of size
1824 1340 48                    pha                            ; low word of size
1825 1341 DA                    phx                            ; id number
1826 1342 5A                    phy                            ; attributes
1827 1343 48                    pha                            ; loc info (ignored)
1828 1344 48                    pha   
1829 1345 22 1F 13 FE           jsl   NewHandleGlue
1830 1349 FA                    plx   
1831 134A 7A                    ply   
1832 134B
1833 134B 60                    rts   
1834 134C
1835 134C                       ENDP 
1836 134C
1837 134C                       END   
